/** <!------------------------------------------------------------------------->
*
*  @file SchM_CanIf.c
*
*  @brief 
*
*  @author
*
*  @description
*
*  @copyright
*    Copyright 2014, dSPACE GmbH. All rights reserved.
*
*<!-------------------------------------------------------------------------->*/
#ifndef SCHM_CANIF_C
#define SCHM_CANIF_C

/*----------------------------------------------------------------------------*\
  DEFINES (OPT)
\*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*\
  INCLUDES
\*----------------------------------------------------------------------------*/

#include "SchM_CanIf.h"

/*----------------------------------------------------------------------------*\
  DEFINES
\*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*\
  TYPEDEFS
\*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*\
  ENUMS
\*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*\
  VARIABLES
\*----------------------------------------------------------------------------*/
UNUSED static uint32 InterruptStatus = 0;
/*----------------------------------------------------------------------------*\
  PARAMETERIZED MACROS
\*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*\
  FUNCTION DEFINITIONS
\*----------------------------------------------------------------------------*/

/*************************************************************************************************\
 ***  FUNCTION:
 ***      SchM_Enter_CanIf
 ***
 ***  DESCRIPTION:
 ***      Enter a module local exclusive area.
 ***
 ***  PARAMETERS:
 ***      Type               Name                Description
 ***      ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ 
 ***      uint8              Instance            
 ***      uint8              ExclusiveArea       
 ***
 ***  RETURNS:
 ***      void
 ***
 ***  SETTINGS:
 ***
\*************************************************************************************************/
void SchM_Enter_CanIf(uint8 Instance, uint8 ExclusiveArea)
{
   switch (Instance) {
      case CANIF_INSTANCE: {
         switch (ExclusiveArea) {
         case SCHM_CANIF_EXCLUSIVE_AREA0: {
               DS_RTOS_INT_SAVE_AND_DISABLE(InterruptStatus);
               break;
            }
         }
         break;
      }
   }
}

/*************************************************************************************************\
 ***  FUNCTION:
 ***      SchM_Exit_CanIf
 ***
 ***  DESCRIPTION:
 ***      Exit a module local exclusive area.
 ***
 ***  PARAMETERS:
 ***      Type               Name                Description
 ***      ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ 
 ***      uint8              Instance            
 ***      uint8              ExclusiveArea       
 ***
 ***  RETURNS:
 ***      void
 ***
 ***  SETTINGS:
 ***
\*************************************************************************************************/
void SchM_Exit_CanIf(uint8 Instance, uint8 ExclusiveArea)
{
   switch (Instance) {
      case CANIF_INSTANCE: {
         switch (ExclusiveArea) {
            case SCHM_CANIF_EXCLUSIVE_AREA0: {
               DS_RTOS_INT_RESTORE(InterruptStatus);
               break;
            }
         }
         break;
      }
   }
}

/*----------------------------------------------------------------------------*\
  FUNCTION PROTOTYPES
\*----------------------------------------------------------------------------*/


#endif/*SCHM_CANIF_C */
/*----------------------------------------------------------------------------*\
 END OF FILE
\*----------------------------------------------------------------------------*/
